# coding:utf-8


#----------------------------------- P1----------------------------------------#

'''
Multiplicacion
Muchas veces, es útil buscar una relación de recursión que solucione el problema
Una relación de recursión incluye uno o más casos base, y una ecuación que de el
resultado de una función en términos precedentes
En este caso, la ecuación es
			multiplicacion(x, y) = multiplicacion(x-1, y) + y, con x > 0
Y el caso base es
					multiplicación(0, y) = 0
(Hacer lo mismo intercambiando x e y es válido)

Otro detalle es cuando x es negativo, en ese caso, basta notar que
					multiplicación(x, y) = -multiplicación(-x, y)

Lo siguiente es decirle esto al computador:
'''

# multiplicacion(a, b): int int --> int
# calcula el producto entre dos enteros a y b de manera recursiva
# ejemplo: multiplicacion(3, 9) entrega 27
# ejemplo: multiplicacion(2, -8) entrega -16
# ejemplo: multiplicacion(-10, 3) entrega -30
# ejemplo: multiplicacion(-5, -7) entrega 35
def multiplicacion(x, y):
	if x < 0:
		return -1 * multiplicacion(-x, y)
	elif x == 0:
		# El programa termina luego de que llega a un return. Si x==0, no
		# se ejecuta nada más que esto
		return 0
	else:
		# Aqui ocurre la recursión, confíen!
		return multiplicacion(x-1, y) + y 

# Tests
assert multiplicacion(3, 9) == 27
assert multiplicacion(2, -8) == -16
assert multiplicacion(-10, 3) == -30
assert multiplicacion(-5, -7) == 35

'''
La pregunta de la división x/y es 'cuantas veces alcanza y en x'. Es decir,
cuantas veces podemos restarle |y| a |x| hasta llegar a un número menor a |y|.
Si x e y son positivos, la relación de recursión sería
					division(x, y) = 1 + división(x-y, y)
Con caso base
					division(x, y) = 0, si x < y
Tenemos cuidado también de no iniciar la recursión principal a menos que x e y
sean positivos
'''

# division(a, b): int int --> int
# calcula la division entera entre los enteros positivos a y b (es
# decir, a/b)
# ejemplo: division(18, 6) entrega 3
# ejemplo: division(11, -4) entrega -2
# ejemplo: division(-12, 4) entrega -3
# ejemplo: division(-8, -3) entrega 2
# ejemplo: division(10, 20) entrega 0
def division(a, b):
    assert b != 0  # evitar division por cero

    if a < 0 and b < 0:
       return division(-a, -b)
    elif a < 0 and b > 0:
       return -1 * division(-a, b)
    elif a > 0 and b < 0:
       return -1 * division(a, -b)
    elif a < b:
        return 0
    else:
        return 1 + division(a - b, b)
# Tests
assert division(18, 6) == 3
assert division(11, -4) == -2
assert division(-12, 4) == -3
assert division(-8, -3) == 2
assert division(10, 20) == 0



'''
En este problema es un poco distinto, pues la relación de recurrencia es un poco
más dificil de encontrar. Pensando en como nosotrs revisamos si una palabra es
palíndromo o no, podemos hacer lo mismo con nuestro programa: revisar si una
los caracteres en los extremos son iguales, y revisar si lo que queda adentro
es un palíndromo. Así, tenemos que la ecuación de recurrencia es
				
	esPalindromo(s) = esPalindromo(s[1 : len(s) -1]) and s[0] == s[len(s) - 1]
Con caso base
		esPalindromo(s) = True, si len(s) == 1 o len(s) == 0
'''


# esPalindromo(palabra): str --> boolean
# retorna True si la palabra es un palindromo y False si no lo es
# ejemplo: esPalindromo("oso") retorna True
# ejemplo: esPalindromo("reconocer") retorna True
# ejemplo: esPalindromo("perro") retorna False
def esPalindromo(palabra):
    if len(palabra) == 1:
        return True
    elif len(palabra) == 0:
        return True
    else:
    	# Esta forma de indexar no incluye el último
        return esPalindromo(palabra[1 : len(palabra) - 1]) and palabra[0] == palabra[len(palabra) - 1]
# Tests
assert esPalindromo("oso")
assert esPalindromo("reconocer")
assert not esPalindromo("perro")


#----------------------------------- P2 ----------------------------------------#

'''
Por muy complicado que suena el problema, debemos extraer la relación de recurrencia
de la definición del triángulo de pascal, en específico, del hecho de que el valor
de una casilla que no está en una arista corresponde a la suma de sus 'padres',
es decir, en la fila anterior:

		pascal(i, j) = pascal(i - 1, j -1) + pascal(i - 1, j)

Y con los casos bases para las casillas en las aristas:

		pascal(i, j) = 1, si i == 1 o i == j

'''

# pascal(fila, columna): int int --> int
# retorna el numero del triangulo de Pascal en la fila y columna indicadas
# ejemplo: pascal(5, 2) retorna 4
# ejemplo: pascal(6, 4) retorna 20
def pascal(fila, columna):
    assert fila > 0
    assert columna > 0
    assert columna <= fila
    
    if columna == 1 or columna == fila:
        return 1
    else:
        return pascal(fila - 1, columna - 1) + pascal(fila -1, columna)
# Tests
assert pascal(5, 2) == 4
assert pascal(7, 4) == 20
